// levenshtein.h
// Levenshtein Edit Distance header file.
// This is an implementation of the Levenshtein Edit Distance algorithm.
#include <stdafx.h>

class Levenshtein
{
	public:
		int GetDistance (BYTE *string1, ULONG length1, BYTE *string2, ULONG length2);
	private:
		BYTE UCase (BYTE c);
		int Minimum3 (int a, int b, int c);
		int *GetCellPointer (int *base, int column, int row, int numcolumns);
		int GetCell (int *base, int column, int row, int numcolumns);
		void PutCell (int *base, int column, int row, int numcolumns, int value);
}; 